/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.entity.compat;

import java.util.Objects;
import net.hecco.bountifulfares.block.custom.compat.CabinetBlock;
import net.hecco.bountifulfares.block.entity.BFBlockEntities;
import net.hecco.bountifulfares.sounds.BFSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.ticks.ScheduledTick;
import org.jetbrains.annotations.Nullable;

public class CabinetBlockEntity
extends RandomizableContainerBlockEntity {
    private static final int MAX_INVENTORY_SIZE = 27;
    private final ContainerOpenersCounter viewerManager;
    private NonNullList<ItemStack> content = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);

    public CabinetBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(BFBlockEntities.CABINET_BLOCK_ENTITY, blockPos, blockState);
    }

    private CabinetBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.viewerManager = new ContainerOpenersCounter(){

            protected void m_142292_(Level world, BlockPos pos, BlockState state) {
                world.m_5594_(null, pos, BFSounds.CABINET_OPEN, SoundSource.BLOCKS, 1.0f, 1.0f);
                CabinetBlockEntity.this.setOpen(state, true);
            }

            protected void m_142289_(Level world, BlockPos pos, BlockState state) {
                CabinetBlockEntity.this.playSound(state, BFSounds.CABINET_OPEN);
                CabinetBlockEntity.this.setOpen(state, false);
            }

            protected void m_142148_(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
            }

            protected boolean m_142718_(Player player) {
                AbstractContainerMenu abstractContainerMenu = player.f_36096_;
                if (abstractContainerMenu instanceof ChestMenu) {
                    ChestMenu genericContainerScreenHandler = (ChestMenu)abstractContainerMenu;
                    Container inventory = genericContainerScreenHandler.m_39261_();
                    return inventory == CabinetBlockEntity.this;
                }
                return false;
            }
        };
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"farmersdelight.container.cabinet");
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return ChestMenu.m_39237_((int)syncId, (Inventory)playerInventory, (Container)this);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.content;
    }

    protected void m_6520_(NonNullList<ItemStack> list) {
        this.content = list;
    }

    public int m_6643_() {
        return 27;
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.viewerManager.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.viewerManager.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.content);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.content = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.content);
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag nbtCompound = new CompoundTag();
        ContainerHelper.m_18976_((CompoundTag)nbtCompound, this.content, (boolean)true);
        return nbtCompound;
    }

    public void tick() {
        if (!this.f_58859_) {
            this.viewerManager.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
        if (this.viewerManager.m_155450_() > 0) {
            this.scheduleTick();
        } else {
            BlockState blockstate = this.m_58900_();
            if (!(blockstate.m_60734_() instanceof CabinetBlock)) {
                this.m_7651_();
                return;
            }
            boolean flag = (Boolean)blockstate.m_61143_((Property)CabinetBlock.OPEN);
            if (flag) {
                this.playSound(blockstate, SoundEvents.f_11724_);
                this.setOpen(blockstate, false);
            }
        }
    }

    private void scheduleTick() {
        Objects.requireNonNull(this.m_58904_()).m_183326_().m_183393_(ScheduledTick.m_193397_((Object)this.m_58900_().m_60734_(), (BlockPos)this.m_58899_()));
    }

    private void setOpen(BlockState state, boolean open) {
        Objects.requireNonNull(this.m_58904_()).m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)CabinetBlock.OPEN, (Comparable)Boolean.valueOf(open)));
    }

    private void playSound(BlockState state, SoundEvent sound) {
        Vec3i vec3i = ((Direction)state.m_61143_((Property)CabinetBlock.FACING)).m_122436_();
        BlockPos pos = this.m_58899_();
        double dX = (double)pos.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double dT = (double)pos.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double dZ = (double)pos.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        Level world = Objects.requireNonNull(this.m_58904_());
        world.m_6263_(null, dX, dT, dZ, sound, SoundSource.BLOCKS, 0.5f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
    }
}

